/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityHelper {
    private EntityHelper() {
    }

    public static int getEntityFacingCardinal(EntityLivingBase entityLivingBase) {
        int n = MathHelper.floor((double)(entityLivingBase.rotationYaw * 4.0f / 360.0f) + 0.5) & 3;
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 3;
            }
        }
        return 4;
    }

    public static ForgeDirection getEntityFacingForgeDirection(EntityLivingBase entityLivingBase) {
        return ForgeDirection.VALID_DIRECTIONS[EntityHelper.getEntityFacingCardinal(entityLivingBase)];
    }

    public static void transferEntityToDimension(Entity entity, int n, ServerConfigurationManager serverConfigurationManager) {
        if (entity instanceof EntityPlayerMP) {
            EntityHelper.transferPlayerToDimension((EntityPlayerMP)entity, n, serverConfigurationManager);
            return;
        }
        WorldServer worldServer = serverConfigurationManager.getServerInstance().worldServerForDimension(entity.dimension);
        entity.dimension = n;
        WorldServer worldServer2 = serverConfigurationManager.getServerInstance().worldServerForDimension(entity.dimension);
        worldServer.removePlayerEntityDangerously(entity);
        if (entity.riddenByEntity != null) {
            entity.riddenByEntity.mountEntity(null);
        }
        if (entity.ridingEntity != null) {
            entity.mountEntity(null);
        }
        entity.isDead = false;
        EntityHelper.transferEntityToWorld(entity, worldServer, worldServer2);
    }

    public static void transferEntityToWorld(Entity entity, WorldServer worldServer, WorldServer worldServer2) {
        WorldProvider worldProvider = worldServer.provider;
        WorldProvider worldProvider2 = worldServer2.provider;
        double d = worldProvider.getMovementFactor() / worldProvider2.getMovementFactor();
        double d2 = entity.posX * d;
        double d3 = entity.posZ * d;
        worldServer.theProfiler.startSection("placing");
        d2 = net.minecraft.util.MathHelper.clamp_double((double)d2, (double)-2.9999872E7, (double)2.9999872E7);
        d3 = net.minecraft.util.MathHelper.clamp_double((double)d3, (double)-2.9999872E7, (double)2.9999872E7);
        if (entity.isEntityAlive()) {
            entity.setLocationAndAngles(d2, entity.posY, d3, entity.rotationYaw, entity.rotationPitch);
            worldServer2.spawnEntityInWorld(entity);
            worldServer2.updateEntityWithOptionalForce(entity, false);
        }
        worldServer.theProfiler.endSection();
        entity.setWorld((World)worldServer2);
    }

    public static void transferPlayerToDimension(EntityPlayerMP entityPlayerMP, int n, ServerConfigurationManager serverConfigurationManager) {
        int n2 = entityPlayerMP.dimension;
        WorldServer worldServer = serverConfigurationManager.getServerInstance().worldServerForDimension(entityPlayerMP.dimension);
        entityPlayerMP.dimension = n;
        WorldServer worldServer2 = serverConfigurationManager.getServerInstance().worldServerForDimension(entityPlayerMP.dimension);
        entityPlayerMP.playerNetServerHandler.sendPacket((Packet)new S07PacketRespawn(entityPlayerMP.dimension, entityPlayerMP.worldObj.difficultySetting, entityPlayerMP.worldObj.getWorldInfo().getTerrainType(), entityPlayerMP.theItemInWorldManager.getGameType()));
        worldServer.removePlayerEntityDangerously((Entity)entityPlayerMP);
        if (entityPlayerMP.riddenByEntity != null) {
            entityPlayerMP.riddenByEntity.mountEntity(null);
        }
        if (entityPlayerMP.ridingEntity != null) {
            entityPlayerMP.mountEntity(null);
        }
        entityPlayerMP.isDead = false;
        EntityHelper.transferEntityToWorld((Entity)entityPlayerMP, worldServer, worldServer2);
        serverConfigurationManager.func_72375_a(entityPlayerMP, worldServer);
        entityPlayerMP.playerNetServerHandler.setPlayerLocation(entityPlayerMP.posX, entityPlayerMP.posY, entityPlayerMP.posZ, entityPlayerMP.rotationYaw, entityPlayerMP.rotationPitch);
        entityPlayerMP.theItemInWorldManager.setWorld(worldServer2);
        serverConfigurationManager.updateTimeAndWeatherForPlayer(entityPlayerMP, worldServer2);
        serverConfigurationManager.syncPlayerInventory(entityPlayerMP);
        for (PotionEffect potionEffect : entityPlayerMP.getActivePotionEffects()) {
            entityPlayerMP.playerNetServerHandler.sendPacket((Packet)new S1DPacketEntityEffect(entityPlayerMP.getEntityId(), potionEffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)entityPlayerMP, n2, n);
    }
}

